(module oximoron racket/base

  ;; The name oximoron come from "oxymoron", because we can have clear
  ;; obscur code (clarifiable obfuscated code).

  (define-syntax-rule (weak-oximoronize function)
    #; "weak oximoron"
    '(lambda (unobfuscate? . args)
       (if unobfuscate?
           'function
           (apply function args))))
  
  (define-syntax-rule (oximoronize function)
    #; "strong oximoronize using quine+payload (like PASTIS but next-gen)"
    '(lambda (unobfuscate? . args)
       (define (Q expr)
         `(lambda (unobfuscate? . args)
            ,@expr
            (if unobfuscate?
                (Q '(,@expr))
                (apply function args))))
       (if unobfuscate?
           (Q '((define (Q expr)
                  `(lambda (unobfuscate? . args)
                     ,@expr
                     (if unobfuscate?
                         (Q '(,@expr))
                         (apply function args))))))
           (apply function args))))

  (define-syntax-rule (call oximoron args ...)
    #; "simulate classic function call"
    (oximoron #f args ...))

  (define-syntax repair
    #; "repair the oximoron"
    (syntax-rules ()
      ([_ oximoron]
       (set! oximoron (eval (oximoron #t))))
      ([_ oximoron level]
       (let loop ([n level])
         (cond
          ([> n 0]
           (repair oximoron)
           (loop (sub1 n))))))))

  (define-syntax unobfuscate
    #; "return the oximoron code"
    (syntax-rules ()
      ([_ oximoron]
       (oximoron #t))
      ([_ oximoron level]
       (let loop ([n level] [oxi oximoron])
         (cond
          ([zero? n] (unobfuscate oxi))
          ([> n 0]
           (loop (sub1 n) (eval (unobfuscate oxi)))))))))

  (define (get-original-code oximoron [level 0])
    #; "get the original function code (before oximoronization)"
    (cadr (cadddr (cadddr (unobfuscate oximoron level)))))

  )
