(define (pastis-generator s)
  ;; s must be a quoted list of named items. A named item is a pair which have
  ;; a name (symbol) as car and a value as cdr.

  ;; For now the generator needs two items: "rewriter" and "payload". Both must
  ;; have a callable (for instance a lambda expression) value.

  ;; In the future there could be an item named "rewrite-features" whose value
  ;; would be a list of code rewriting features (choosen among a given list) to
  ;; use.
  ;; We also need a syntax to add custom rewriting features.

  (define (pastis-get-item item s)
    ;; get the definition of item from s
    (if (eq? (caar s) item)
        (cdar s)
        (pastis-get-item item (cdr s))))

  (let ((quine-code
         `((define (pastis-rewrite x)
             (,(pastis-get-item 'rewriter s) x))
           (define (pastis-payload x)
             (,(pastis-get-item 'payload s) x))
           (define (pastis-ls l)
             (map (lambda (x)
                    (write (pastis-rewrite x))
                    (display " ")) l))
           (define (pastis-code l)
             (display "(") (pastis-ls l)
             (display "(pastis-code '(") (pastis-ls l)
             (display ")) (pastis-payload args))\n")))))

    `(lambda (args) ,@quine-code
             (pastis-code '(lambda (args) ,@quine-code))
             (pastis-payload args))))
