(define (rewrite s)
  (if (pair? s)
      (case (car s)
        ((if) (rewrite-if s))
        ((else) (rewrite-else s))
        ((cond) (rewrite-cond s))
        ((case) (rewrite-case s))
        ((let) (rewrite-let s))
        ((lambda) (rewrite-lambda s))
        ((define) (rewrite-define s))
        ((quote) (rewrite-quote s))
        ((quasiquote) (rewrite-quasiquote s))
        ((unquote) (rewrite-unquote s))
        ((unquote-splicing) (rewrite-unquote-splicing s))
        ((and) (rewrite-and s))
        ((or) (rewrite-or s))
        (else (map rewrite s)))
      s))
