(define (rewrite-if s)
  (define get-cond (rewrite (cadr s)))
  (define get-then (rewrite (caddr s)))
  (define get-else
    (if (not (null? (cdddr s)))
        (rewrite (cadddr s))))
  (define get-else-beginned
    (if (and (pair? get-else)
             (eq? (car get-else) 'else))
        `(begin ,@(cdr get-else))
        (if (eq? get-else #!unspecific)
            '#!unspecific
            get-else)))

  (if (and (pair? get-cond)
           (eq? (car get-cond) 'not)
           (< (random 3) 2))
      (rewrite-if `(if ,@(cdr get-cond) ,get-else-beginned ,get-then)))
      (case (random 5)
        ((0) `(if (not ,get-cond) ,get-else-beginned ,get-then))
        ((1) `(cond (,get-cond ,get-then) (else ,get-else-beginned)))
        ((2) `(cond ((not ,get-cond) ,get-else-beginned)
                    (,get-cond ,get-then) (else 42)))
        ((3) `(case ,get-cond ((#f) ,get-else-beginned) ((#t) ,get-then)))
        ((4) (if (eq? get-else #!unspecific)
                 `(if ,get-cond ,get-then)
                 `(if ,get-cond ,get-then ,get-else)))))


(define (rewrite-cond s)
  (define get-cond
    (if (eq? (caadr s) 'else) #t (rewrite (caadr s))))
  (define get-then (rewrite (cdadr s)))
  (define get-rest
    (if (not (or (null? (cddr s))
                 (eq? (caddr s) #!unspecific)
                 ;(eq? (cadr s) 'else)
                 (eq? (caddr s) 'else)))
        (rewrite `(cond ,@(cddr s)))))

  (if (eq? get-rest #!unspecific)
      (case (random 3)
        ((0) `(if ,get-cond ,@get-then))
        ((1) `(cond (,get-cond ,@get-then)))
        ((2) `(case ,get-cond
                ((#t) ,@get-then))))
      (case (random 4)
        ((0) `(if ,get-cond ,@get-then ,get-rest))
        ((1) `(if (not ,get-cond) ,get-rest ,@get-then))
        ((2) `(cond (,get-cond ,@get-then) (#t ,get-rest)))
        ((3) `(case ,get-cond
                ((#t) ,@get-then)
                ((#f) ,get-rest))))))


(define (rewrite-case s)
  (define get-key (rewrite (cadr s)))
  (define get-next-case-object (caaddr s))
  (define get-next-case-exprs (cdaddr s))

  ; generate a random (supposedly unique) variable name to prevent
  ; capture problems when rewriting a code containing a variable with
  ; the same name (especially this very code)
  (define case-key
    (string->symbol
     (string-append "key"
                    (number->string (random 99999999999999999999999999)))))

  (define get-rest
    (if (not (or (null? (cdddr s))
                 (eq? (caddr s) 'else)))
        (rewrite `(case ,case-key ,@(cdddr s)))))

  (define (disjonction list)
    (define (op-list list)
      (if (null? list) '()
          `((eq? ,case-key (quote ,(car list)))
            ,@(op-list (cdr list)))))
    (if (list? list)
        `((or ,@(op-list list)))
        `((eq? ,case-key (quote ,list)))))

  (if (eq? get-next-case-object 'else)
      `(begin ,@get-next-case-exprs)
      (case (if (eq? get-rest #!unspecific)
                0
                (random 3))
        ((0) `(let ((,case-key ,get-key))
                (if ,@(disjonction get-next-case-object)
                    (begin ,@get-next-case-exprs)
                    ,get-rest)))
        ((1) `(let ((,case-key ,get-key))
                (cond
                 (,@(disjonction get-next-case-object)
                  ,@get-next-case-exprs)
                 (#t ,get-rest))))
        ((2) `(let ((,case-key ,get-key))
                (case ,case-key
                  (,get-next-case-object ,@get-next-case-exprs)
                  (else ,get-rest)))))))


(define (rewrite-else s)
  (define get-else (rewrite (cdr s)))

  (case 1;(random 2)
    ((0) `(#t ,@get-else))
    ((1) `(else ,@get-else))))


(define (rewrite-let s)
  `(let ,(cadr s) ,@(rewrite (cddr s))))


(define (rewrite-lambda s)
  `(lambda ,(cadr s) ,@(rewrite (cddr s))))


(define (rewrite-define s)
  `(define ,(cadr s) ,@(rewrite (cddr s))))


(define (rewrite-quote s) s)


(define (rewrite-quasiquote s) s)


(define (rewrite-unquote s)
  `(unquote ,@(rewrite (cadr s))))

(define (rewrite-unquote-splicing s) s)


;; remember not to want to add the possibility of swapping `or` or `andè
;; operands: scheme has lazy evaluation for this operators and the swap could
;; results in a change in semantics

(define (rewrite-or s)
  `(or ,@(map rewrite (cdr s))))


(define (rewrite-and s)
  `(and ,@(map rewrite (cdr s))))
