import pygame

from palette import *
from tools import *

class MiniPaint:

    def __init__ (self):
        ## initialize pygame
        pygame.init()

        ## open new window
        self._window = pygame.display.set_mode((600, 420), pygame.DOUBLEBUF)
        pygame.display.set_caption('MiniPaint')

        ## create canvas
        self._canvas = pygame.Surface((600, 420), pygame.SRCALPHA, 32)

        ## initialize MiniPaint
        self._bgcolor = pygame.Color(255, 255, 255, 255) # white
        self._shapes = pygame.sprite.OrderedUpdates()
        self._palette = Palette(self._canvas.get_size())
        self._tools = Tools(self._canvas.get_size())

    def run (self):
        done = False
        while not done:
            for event in pygame.event.get():
                pass # MODIFIER

            ## clear window
            self._canvas.fill(self._bgcolor)

            ## draw existing shapes
            self._shapes.draw(self._canvas)

            ## draw current shape
            # COMPLÉTER

            ## display color picker
            # COMPLÉTER

            ## update display
            self._window.blit(self._canvas, (0, 0))
            pygame.display.flip()

        pygame.quit()


if __name__ == '__main__':
    mp = MiniPaint()
    mp.run()
