import sys
import pygame

from shape import Shape

class Tools:
    Palette = 0
    Line = 1
    Circle = 2
    Rectangle = 3

    def __init__ (self, canvas_size):
        ## canvas
        self._canvas_size = canvas_size

        ## current tool setup
        self._active = Tools.Line
        self._previous = Tools.Palette
        self._pos = (0, 0)

    def get_active_tool (self):
        return self._active

    def switch_tool (self, key):
        self._previous = self._active
        if (key == pygame.K_p):
            self._active = Tools.Palette
        elif (key == pygame.K_l):
            self._active = Tools.Line
        elif (key == pygame.K_c):
            self._active = Tools.Circle
        elif (key == pygame.K_r):
            self._active = Tools.Rectangle
        else:
            sys.stderr.write('[ERROR] unknown tool for ' + chr(key) + '\n')

    def switch_back (self):
        self._active = self._previous

    def set_position (self, pos):
        self._pos = pos

    def make_shape (self, color, pos):
        surface = pygame.Surface(self._canvas_size, pygame.SRCALPHA, 32)

        pygame.draw.circle(surface, color, pos, 1) # MODIFIER

        return Shape(surface)
