#include <stdlib.h>
#include <assert.h>
#include "point.h"

struct Point {
  int dimension;
  int *coordinates;
};

Point *
Point_new (int dimension, int *coordinates)
{
  Point *self;

  self = malloc(sizeof(*self));
  assert(self != NULL);

  self->dimension = dimension;

  self->coordinates = malloc(dimension * sizeof(self->coordinates));
  assert(self->coordinates != NULL);

  if (coordinates != NULL) {
    for (int i = 0; i < dimension; i++) {
      self->coordinates[i] = coordinates[i];
    }
  }

  return self;
}

void
Point_delete (Point *self)
{
  free(self->coordinates);
  free(self);
}

/* ----- */

int
Point_getDimension (Point *self)
{
  return self->dimension;
}

/* ----- */

int
Point_get (Point *self, int coordinate)
{
  if (coordinate >= 0 && coordinate < self->dimension)
    return self->coordinates[coordinate];
  return 0;
}

int
Point_set (Point *self, int coordinate, int value)
{
  if (coordinate >= 0 && coordinate < self->dimension) {
    self->coordinates[coordinate] = value;
    return 1;
  }
  return 0;
}

/* ----- */

void
Point_translate (Point *self, int *vector)
{
  for (int i = 0; i < self->dimension; i++) {
    self->coordinates[i] += vector[i];
  }
}
