#include <stdlib.h>
#include <assert.h>
#include "point.h"
#include "square.h"

struct Square {
  Point *origin;
  int width;
};

Square *
Square_new (int x, int y, int width)
{
  Square *self;

  self = malloc(sizeof(*self));
  assert(self != NULL);

  self->origin = Point_new(2, (int[]){x, y});

  self->width = width;

  return self;
}

void
Square_delete (Square *self)
{
  Point_delete(self->origin);
  free(self);
}

/* ----- */

int
Square_getWidth (Square *self)
{
  return self->width;
}

Point *
Square_getOrigin (Square *self)
{
  return self->origin;
}

/* ----- */

void
Square_resize (Square *self, int width)
{
  self->width = width;
}

void
Square_translate (Square *self, int x, int y)
{
  Point_translate(self->origin, (int[]){x, y});
}
