import sys
import pygame

class Player:

    def __init__ (self):
        self.sheet = pygame.image.load("characsheet.png").convert_alpha()
        self.position = [100, 50]
        self.width = (self.sheet.get_width() // 4)
        self.height = (self.sheet.get_height() // 4)
        self.sprite = pygame.Rect(0, 0, self.width, self.height)

    def display (self, surface):
        surface.blit(self.sheet, self.position, self.sprite)

    def move (self, horz, vert):
        self.position[0] += horz
        self.position[1] += vert

def game ():
    size = width, height = 800, 600
    screen = pygame.display.set_mode(size, pygame.DOUBLEBUF)
    pygame.display.set_caption('Fac à l\'essai')
    clock = pygame.time.Clock()

    white = pygame.Color(255,255,255)

    bg = pygame.Surface(size)
    bg.fill(white)

    player = Player()

    done = False

    while not done:
        for event in pygame.event.get([pygame.QUIT]):
            if event.type == pygame.QUIT:
                done = True

        pressed = pygame.key.get_pressed()
        if pressed[pygame.K_DOWN]:
            player.move(0, 2)
        elif pressed[pygame.K_RIGHT]:
            player.move(2, 0)
        elif pressed[pygame.K_LEFT]:
            player.move(-2, 0)
        elif pressed[pygame.K_UP]:
            player.move(0, -2)

        clock.tick(15)
        screen.blit(bg, (0,0))
        player.display(screen)
        pygame.display.flip()

if __name__ == '__main__':
    pygame.init()
    game()
    pygame.quit()
