import sys
import pygame
import random

class Player:

    def __init__ (self):
        self.sheet = pygame.image.load("characsheet.png").convert_alpha()
        self.position = [100, 500]
        self.width = (self.sheet.get_width() // 4)
        self.height = (self.sheet.get_height() // 4)
        self.sprite = pygame.Rect(0, 0, self.width, self.height)
        self.anim_step = 0
        self.jumping = 0
        self.jump_start = 0
        self.jump_floor = self.position[1]

    def display (self, surface):
        if self.jumping:
            self.sprite.x = 0
        else:
            self.sprite.x = self.width * self.anim_step
        surface.blit(self.sheet, self.position, self.sprite)

    def move (self, horz, vert):
        self.position[0] += horz
        self.position[1] += vert
        self.anim_step = (self.anim_step + 1) % 4

    def rest (self):
        self.anim_step = 1

    def set_direction (self, direction):
        # 0 = down
        # 1 = right
        # 2 = left
        # 3 = up
        self.sprite.y = self.height * direction

    def update (self, road):
        if self.jumping:
            time = pygame.time.get_ticks() - self.jump_start
            if time < 500:
                self.position[1] -= 8
            elif self.position[1] < self.jump_floor:
                self.position[1] += 4
            else:
                self.jumping = False
            return
        pos = pygame.Rect(self.position[0], self.position[1] + self.height // 2,
                          self.width, self.height // 2)
        if pos.top < road.top:
            self.position[1] += road.top - pos.top
        if pos.bottom > road.bottom:
            self.position[1] += road.bottom - pos.bottom
        if pos.left < road.left:
            self.position[0] += road.left - pos.left
        if pos.right > road.right:
            self.position[0] += road.right - pos.right

    def jump (self):
        self.jump_start = pygame.time.get_ticks()
        self.jump_floor = self.position[1]
        self.jumping = True

    def get_rect (self):
        return pygame.Rect(self.position[0], self.position[1],
                           self.width, self.height)

class Ennemy:

    def __init__ (self):
        self.sprite = pygame.image.load("police.png").convert_alpha()
        self.position = [800, 500]
        self.speed = 10
        self.rect = pygame.Rect(0, 0, self.sprite.get_width(), self.sprite.get_height())

    def update (self):
        self.position[0] -= self.speed
        if self.position[0] < -self.rect.width:
            self.position[0] = 800
            self.position[1] = random.randint(450, 550)
            self.speed += 2

    def display (self, surface):
        surface.blit(self.sprite, self.position)

    def crash_in (self, rect):
        self.rect.topleft = self.position
        return self.rect.colliderect(rect)


def game ():
    size = width, height = 800, 600
    screen = pygame.display.set_mode(size, pygame.DOUBLEBUF)
    pygame.display.set_caption('Fac à l\'essai')
    clock = pygame.time.Clock()

    bg = pygame.image.load("road.png").convert()
    road = pygame.Rect(0, 413, width, height - 413)

    player = Player()
    police = Ennemy()

    done = False

    while not done:
        for event in pygame.event.get([pygame.QUIT, pygame.KEYDOWN]):
            if event.type == pygame.QUIT:
                done = True
            elif event.type == pygame.KEYDOWN:
                if event.key == pygame.K_DOWN:
                    player.set_direction(0)
                elif event.key == pygame.K_RIGHT:
                    player.set_direction(1)
                elif event.key == pygame.K_LEFT:
                    player.set_direction(2)
                elif event.key == pygame.K_UP:
                    player.set_direction(3)
                elif event.key == pygame.K_SPACE:
                    player.jump()

        pressed = pygame.key.get_pressed()
        if pressed[pygame.K_DOWN]:
            player.move(0, 2)
        elif pressed[pygame.K_RIGHT]:
            player.move(2, 0)
        elif pressed[pygame.K_LEFT]:
            player.move(-2, 0)
        elif pressed[pygame.K_UP]:
            player.move(0, -2)
        else:
            player.rest()
        player.update(road)

        police.update()

        if police.crash_in(player.get_rect()):
            done = True

        clock.tick(15)
        screen.blit(bg, (0,0))
        player.display(screen)
        police.display(screen)
        pygame.display.flip()

if __name__ == '__main__':
    pygame.init()
    game()
    pygame.quit()
