exception UnknownCmd of string

let to_python expr =
  let lst = String.split_on_char ' ' expr in
  let cmd = List.hd lst in
  let args = List.map String.to_int (List.tl lst) in
  match cmd with
  | "num"  -> Printf.sprintf "print(%d)" (List.hd args)
  | "exit" -> Printf.sprintf "exit()"
  | _      -> raise (UnknownCmd cmd)

let compile ic oc =
  let rec comp line =
    try
      let expr = input_line ic in
      Printf.fprintf oc "%s\n" (to_python expr) ;
      comp (line + 1)
    with
    | End_of_file -> ()
    | UnknownCmd cmd ->
       Printf.eprintf "Error on line %d: unknown command '%s'.\n" line cmd
  in
  Printf.fprintf oc "#!/usr/bin/env python\n" ;
  comp 1
  
let () = compile Stdlib.stdin Stdlib.stdout
