%{
  open Ast.Bool
%}

%token <bool> Lbool
%token Lnot Land Lor Lxor Lopar Lcpar Leof

%left Land Lor Lxor
%right Lnot

%start prog

%type <Ast.Bool.expr> prog

%%

prog:
| expr Leof { $1 }
;

expr:
| Lbool            { Bool ($1) }
| Lnot expr        { Not ($2) }
| Lopar expr Lcpar { $2 }
| expr Land expr   { And ($1, $3) }
| expr Lor  expr   { Or ($1, $3) }
| expr Lxor expr   { Xor ($1, $3) }
;
