from itertools import product

class Logic:

    def __init__ (self):
        self._board = [ [ None for i in range(0, 8) ] for i in range(0, 8) ]
        self._empty_cells = list(product(range(0, 8), range(0, 8)))
        self._scores = [ 0, 0 ]

    def board (self):
        return self._board

    def empty_cells (self):
        return self._empty_cells

    def scores (self):
        return self._scores

    def set_piece (self, player, cell):
        if self._board[cell[0]][cell[1]] == None:
            self._empty_cells.remove(cell)
        else:
            self._scores[1 - player] -= 1
        self._board[cell[0]][cell[1]] = player
        self._scores[player] += 1

    def is_legal_move (self, player, cell):
        # is it okay to pass?
        if cell is None:
            for c in self._empty_cells:
                if len(self.get_flipped(player, c)) > 0:
                    return False
            return True

        # is the action legal?
        return (cell in self._empty_cells and
                len(self.get_flipped(player, cell)) > 0)


    def get_flipped (self, player, cell):
        flipped = []

        # top
        cells = []
        if cell[1] > 0:
            i = cell[0]
            j = cell[1] - 1
            while j >= 0:
                if self._board[i][j] == (1 - player):
                    cells.append((i, j))
                elif self._board[i][j] == player:
                    flipped.append(cells)
                    break
                elif self._board[i][j] == None:
                    break
                j -= 1

        # top right
        cells = []
        if cell[0] < 7 and cell[1] > 0:
            i = cell[0] + 1
            j = cell[1] - 1
            while i <= 7 and j >= 0:
                if self._board[i][j] == (1 - player):
                    cells.append((i, j))
                elif self._board[i][j] == player:
                    flipped.append(cells)
                    break
                elif self._board[i][j] == None:
                    break
                i += 1
                j -= 1

        # right
        cells = []
        if cell[0] < 7:
            i = cell[0] + 1
            j = cell[1]
            while i <= 7:
                if self._board[i][j] == (1 - player):
                    cells.append((i, j))
                elif self._board[i][j] == player:
                    flipped.append(cells)
                    break
                elif self._board[i][j] == None:
                    break
                i += 1

        # bottom right
        cells = []
        if cell[0] < 7 and cell[1] < 7:
            i = cell[0] + 1
            j = cell[1] + 1
            while i <= 7 and j <= 7:
                if self._board[i][j] == (1 - player):
                    cells.append((i, j))
                elif self._board[i][j] == player:
                    flipped.append(cells)
                    break
                elif self._board[i][j] == None:
                    break
                i += 1
                j += 1

        # bottom
        cells = []
        if cell[1] < 7:
            i = cell[0]
            j = cell[1] + 1
            while j <= 7:
                if self._board[i][j] == (1 - player):
                    cells.append((i, j))
                elif self._board[i][j] == player:
                    flipped.append(cells)
                    break
                elif self._board[i][j] == None:
                    break
                j += 1

        # bottom left
        cells = []
        if cell[0] > 0 and cell[1] < 7:
            i = cell[0] - 1
            j = cell[1] + 1
            while i >= 0 and j <= 7:
                if self._board[i][j] == (1 - player):
                    cells.append((i, j))
                elif self._board[i][j] == player:
                    flipped.append(cells)
                    break
                elif self._board[i][j] == None:
                    break
                i -= 1
                j += 1

        # left
        cells = []
        if cell[0] > 0:
            i = cell[0] - 1
            j = cell[1]
            while i >= 0:
                if self._board[i][j] == (1 - player):
                    cells.append((i, j))
                elif self._board[i][j] == player:
                    flipped.append(cells)
                    break
                elif self._board[i][j] == None:
                    break
                i -= 1

        # top left
        cells = []
        if cell[0] > 0 and cell[1] > 0:
            i = cell[0] - 1
            j = cell[1] - 1
            while i >= 0 and j >= 0:
                if self._board[i][j] == (1 - player):
                    cells.append((i, j))
                elif self._board[i][j] == player:
                    flipped.append(cells)
                    break
                elif self._board[i][j] == None:
                    break
                i -= 1
                j -= 1

        cells = []
        for direction in flipped:
            for cell in direction:
                cells.append(cell)

        return cells
