import pygame

class Mat:

    def __init__ (self, size):
        # Surface for the mat
        self._mat = pygame.Surface(size, pygame.SRCALPHA, 32)

        # Drawing the mat
        mat = pygame.image.load('feutrine.jpg').convert()
        self._cellwidth = mat.get_width()
        for i in range(0, 8):
            for j in range(0, 8):
                self._mat.blit(mat, (4 + i * self._cellwidth, 4 + j * self._cellwidth))

        # Drawing the lines
        c = pygame.Color(0, 0, 0)
        pygame.draw.line(self._mat, c, (0, 0), (size[0], 0), 8)
        pygame.draw.line(self._mat, c, (0, 0), (0, size[1]), 8)
        pygame.draw.line(self._mat, c, (size[0] - 1, 0), (size[0] - 1, size[1] - 1), 8)
        pygame.draw.line(self._mat, c, (0, size[1] - 4), (size[0] - 1, size[1] - 4), 8)
        for i in range(0, 8):
            pygame.draw.line(self._mat, c,
                             (4 + i * mat.get_width() - 2, 0),
                             (4 + i * mat.get_width() - 2, size[1]),
                             4)
            pygame.draw.line(self._mat, c,
                             (0,       4 + i * mat.get_height() - 2),
                             (size[0], 4 + i * mat.get_height() - 2),
                             4)

        # Players' color
        self._colors = [ pygame.Color(255, 255, 255),
                         pygame.Color(0, 0, 0) ]

    def get (self):
        return self._mat

    def place_piece (self, player, cell):
        pygame.draw.circle(self._mat, self._colors[player],
                           (3 + cell[0] * self._cellwidth + (self._cellwidth // 2),
                            3 + cell[1] * self._cellwidth + (self._cellwidth // 2)),
                           30)

    
