import pygame

class Action:
    QUIT = 0 # for human users only, quit the game
    PLAY = 1

    def __init__ (self, type, value):
        self.type = type
        self.value = value # cell coordinates or None to pass

class Player:

    def __init__ (self, id, name):
        self._id = id
        self._name = name

    def name (self):
        return self._name

    def play (self, logic):
        event = pygame.event.wait()
        if event.type == pygame.QUIT:
            return Action(Action.QUIT, None)
        if event.pos[1] > 600:
            return Action(Action.PLAY, None)
        cell = (min(event.pos[0] // 74, 7), min(event.pos[1] // 74, 7))
        return Action(Action.PLAY, cell)
