import pygame
from mat import Mat
from player import Action, Player
from logic import Logic

class Reversi:

    def __init__ (self):
        # Initialize game window
        self._window = pygame.display.set_mode((596, 650), pygame.DOUBLEBUF)
        pygame.display.set_caption('Reversi')

        # Initialize message
        self._msg = pygame.font.Font(None, 40)
        self._score = pygame.font.Font(None, 25)
        self._textcolor = pygame.Color(255, 255, 255)
        self.message("Launching game...")
        pygame.display.flip()
        pygame.time.wait(500)

        # Game logic
        self._logic = Logic()

        # Initialize players
        self._players = [ Player(0, 'White'), Player(1, 'Black') ]

        # Initialize mat
        self._mat = Mat((596, 600))
        self.move(0, (3, 3))
        self.move(0, (4, 4))
        self.move(1, (3, 4))
        self.move(1, (4, 3))
        self._window.blit(self._mat.get(), (0, 0))
        pygame.display.flip()

        # Blocking undesirable events,
        # keeping only "QUIT" (window closed)
        # and "MOUSEBUTTONDOWN" (user click)
        pygame.event.set_blocked([ pygame.ACTIVEEVENT,
                                   pygame.KEYDOWN,
                                   pygame.KEYUP,
                                   pygame.MOUSEMOTION,
                                   pygame.MOUSEBUTTONUP,
                                   pygame.JOYAXISMOTION,
                                   pygame.JOYBALLMOTION,
                                   pygame.JOYHATMOTION,
                                   pygame.JOYBUTTONUP,
                                   pygame.JOYBUTTONDOWN,
                                   pygame.VIDEORESIZE,
                                   pygame.VIDEOEXPOSE,
                                   pygame.USEREVENT ])
        pygame.event.clear()

    def message (self, msg, scores = (0, 0)):
        pygame.draw.rect(self._window, pygame.Color(0, 0, 0),
                         (0, 600, 596, 50))
        p = self._score.render("× pass", 1, self._textcolor)
        self._window.blit(p, (10, 605))

        text = self._msg.render(msg, 1, self._textcolor)
        self._window.blit(text, (200 - text.get_width() // 2,
                                 625 - text.get_height() // 2))

        w = self._score.render("W: " + str(scores[0]), 1, self._textcolor)
        b = self._score.render("B: " + str(scores[1]), 1, self._textcolor)
        self._window.blit(w, (530, 605))
        self._window.blit(b, (533, 625))

    def move (self, player, cell):
        self._logic.set_piece(player, cell)
        self._mat.place_piece(player, cell)

    def play (self):
        player = 0
        while len(self._logic.empty_cells()) > 0:
            self.message(self._players[player].name() + "'s turn",
                         self._logic.scores())
            pygame.display.flip()

            action = self._players[player].play(self._logic)
            if action.type == Action.QUIT:
                return
            else: # action.type == Action.PLAY
                cell = action.value
                if self._logic.is_legal_move(player, cell):
                    if cell is not None:
                        self.move(player, cell)
                        for cell in self._logic.get_flipped(player, cell):
                            self.move(player, cell)
                    player = 1 - player

            # Update display
            self._window.blit(self._mat.get(), (0, 0))
            pygame.display.flip()

        scores = self._logic.scores()
        self.message("Winner is " + self._players[int(scores[0] <= scores[1])].name(),
                     scores)
        pygame.display.flip()
        pygame.event.wait()


if __name__ == '__main__':
    pygame.init()
    Reversi().play()
    pygame.quit()
