import pygame
from math import pi

pygame.init()
size = width, height = 300, 300
screen = pygame.display.set_mode(size, pygame.DOUBLEBUF)
pygame.key.set_repeat(500, 100)

white = pygame.Color(255,255,255)
black = pygame.Color(0,0,0)

bg = pygame.Surface(size, pygame.SRCALPHA, 32)
pygame.draw.line(bg, black, (30,20), (30,100), 10)
pygame.draw.line(bg, black, (30,100), (70,100), 10)
pygame.draw.line(bg, black, (80,50), (120,20), 10)
pygame.draw.line(bg, black, (120,20), (120,100), 10)



player = pygame.image.load('player.png').convert()
player.set_colorkey(white)
up = pygame.Rect(25, 0, 25, 31)
down = pygame.Rect(0, 0, 25, 31)
left = pygame.Rect(25, 31, 25, 31)
right = pygame.Rect(0, 31, 25, 31)
direction = down
position = [width // 2 - 25 // 2, height // 2 - 31 // 2]

done = False
while not done:
    for event in pygame.event.get():
        # manage events
        if event.type == pygame.QUIT:
            done = True
        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_UP:
                direction = up
                position[1] -= 2
            elif event.key == pygame.K_DOWN:
                direction = down
                position[1] += 2
            elif event.key == pygame.K_LEFT:
                direction = left
                position[0] -= 2
            elif event.key == pygame.K_RIGHT:
                direction = right
                position[0] += 2

    # clear screen
    screen.fill(white)
    # update display
    screen.blit(bg, (0, 0))
    screen.blit(player, position, direction)
    # flip double buffer
    pygame.display.flip()

pygame.quit()
