#include <cstdlib>
#include <SFML/Graphics.hpp>
#include "main.hpp"
#include "board.hpp"
#include <iostream>

Board::Board ()
{
  for (int i = 0; i < 3; i++) {
    for (int j = 0; j < 3; j++) {
      cells_[i + 3 * j] = new Cell(i, j);
    }
  }
  current_cell_ = -1;
}

Board::~Board ()
{
  for (int c = 0; c < 9; c++) {
    delete cells_[c];
  }
}

void
Board::setCurrentCell (int mouse_x, int mouse_y)
{
  current_cell_ = -1;
  for (int c = 0; c < 9; c++) {
    if (cells_[c]->contains(mouse_x, mouse_y) &&
        cells_[c]->getPlayer() == None) {
      current_cell_ = c;
      return;
    }
  }
}

bool
Board::play (Player player)
{
  if (current_cell_ < 0) return false;
  cells_[current_cell_]->play(player);
  return true;
}


/**
   0 1 2
   3 4 5
   6 7 8
*/
Player
Board::getWinner ()
{
  if (current_cell_ < 0) return None;

  int cur = current_cell_;
  current_cell_ = -1;
  Player last = cells_[cur]->getPlayer();
  switch (cur) {
  case 0:
    if ((cells_[1]->getPlayer() == last && cells_[2]->getPlayer() == last) ||
        (cells_[3]->getPlayer() == last && cells_[6]->getPlayer() == last) ||
        (cells_[4]->getPlayer() == last && cells_[8]->getPlayer() == last))
      return last;
    break;
  case 1:
    if ((cells_[0]->getPlayer() == last && cells_[2]->getPlayer() == last) ||
        (cells_[4]->getPlayer() == last && cells_[7]->getPlayer() == last))
      return last;
    break;
  case 2:
    if ((cells_[0]->getPlayer() == last && cells_[1]->getPlayer() == last) ||
        (cells_[4]->getPlayer() == last && cells_[6]->getPlayer() == last) ||
        (cells_[5]->getPlayer() == last && cells_[8]->getPlayer() == last))
      return last;
    break;
  case 3:
    if ((cells_[0]->getPlayer() == last && cells_[6]->getPlayer() == last) ||
        (cells_[4]->getPlayer() == last && cells_[5]->getPlayer() == last))
      return last;
    break;
  case 4:
    if ((cells_[0]->getPlayer() == last && cells_[8]->getPlayer() == last) ||
        (cells_[1]->getPlayer() == last && cells_[7]->getPlayer() == last) ||
        (cells_[2]->getPlayer() == last && cells_[6]->getPlayer() == last) ||
        (cells_[3]->getPlayer() == last && cells_[5]->getPlayer() == last))
      return last;
    break;
  case 5:
    if ((cells_[2]->getPlayer() == last && cells_[8]->getPlayer() == last) ||
        (cells_[3]->getPlayer() == last && cells_[4]->getPlayer() == last))
      return last;
    break;
  case 6:
    if ((cells_[0]->getPlayer() == last && cells_[3]->getPlayer() == last) ||
        (cells_[2]->getPlayer() == last && cells_[4]->getPlayer() == last) ||
        (cells_[7]->getPlayer() == last && cells_[8]->getPlayer() == last))
      return last;
    break;
  case 7:
    if ((cells_[1]->getPlayer() == last && cells_[4]->getPlayer() == last) ||
        (cells_[6]->getPlayer() == last && cells_[8]->getPlayer() == last))
      return last;
    break;
  case 8:
    if ((cells_[0]->getPlayer() == last && cells_[4]->getPlayer() == last) ||
        (cells_[2]->getPlayer() == last && cells_[5]->getPlayer() == last) ||
        (cells_[6]->getPlayer() == last && cells_[7]->getPlayer() == last))
      return last;
    break;
  default: return None;
  }
  return None;
}

void
Board::drawX (sf::RenderTarget *rt, sf::Vector2i center, int opacity)
{
  int len = CELL_WIDTH / 3;
  rt->Draw(sf::Shape::Line(sf::Vector2f(center.x - len, center.y - len),
                           sf::Vector2f(center.x + len, center.y + len),
                           10, sf::Color(0, 0, 0, opacity)));
  rt->Draw(sf::Shape::Line(sf::Vector2f(center.x - len, center.y + len),
                           sf::Vector2f(center.x + len, center.y - len),
                           10, sf::Color(0, 0, 0, opacity)));
}

void
Board::drawO (sf::RenderTarget *rt, sf::Vector2i center, int opacity)
{
  int len = CELL_WIDTH / 3;
  rt->Draw(sf::Shape::Circle(center.x, center.y, len, sf::Color(0, 0, 0, 0),
                               10, sf::Color(0, 0, 0, opacity)));
}

void
Board::displayGrid (sf::RenderTarget *rt)
{
  for (int c = 0; c < 9; c++) {
    cells_[c]->display(rt);
    switch (cells_[c]->getPlayer()) {
    case X:
      drawX(rt, cells_[c]->getCenter());
      break;
    case O:
      drawO(rt, cells_[c]->getCenter());
      break;
    default: break;
    }
  }
}

void
Board::showNextMove (sf::RenderTarget *rt, Player player)
{
  if (current_cell_ < 0) return;

  sf::Vector2i center = cells_[current_cell_]->getCenter();

  if (player == X) {
    drawX(rt, center, 100);
  }
  else {
    drawO(rt, center, 100);
  }
}
