#include <SFML/Graphics.hpp>
#include "main.hpp"
#include "cell.hpp"

Cell::Cell (int i, int j)
  : pawn_(None)
{
  sprite_ = sf::Shape::Rectangle(i * CELL_WIDTH + (i + 1) * CELL_PADDING,
                                 j * CELL_WIDTH + (j + 1) * CELL_PADDING,
                                 (i + 1) * CELL_WIDTH + (i + 1) * CELL_PADDING,
                                 (j + 1) * CELL_WIDTH + (j + 1) * CELL_PADDING,
                                 sf::Color(190, 255, 190));
  zone_ = sf::IntRect(i * CELL_WIDTH + (i + 1) * CELL_PADDING,
                      j * CELL_WIDTH + (j + 1) * CELL_PADDING,
                      (i + 1) * CELL_WIDTH + (i + 1) * CELL_PADDING,
                      (j + 1) * CELL_WIDTH + (j + 1) * CELL_PADDING);
}

Cell::~Cell ()
{}

bool
Cell::contains (int mouse_x, int mouse_y)
{
  return zone_.Contains(mouse_x, mouse_y);
}

sf::Vector2i
Cell::getCenter ()
{
  return sf::Vector2i((zone_.Left + zone_.Right) / 2,
                      (zone_.Top + zone_.Bottom) / 2);
}

void
Cell::play (Player pawn)
{
  pawn_ = pawn;
}

Player
Cell::getPlayer ()
{
  return pawn_;
}

void
Cell::display (sf::RenderTarget *rt)
{
  rt->Draw(sprite_);
}
