#include <SFML/Graphics.hpp>
#include "main.hpp"
#include "menu.hpp"
#include "board.hpp"
#include "tictactoe.hpp"

TicTacToe::TicTacToe ()
{
  win_ = new sf::RenderWindow(sf::VideoMode(GAME_WIDTH, GAME_HEIGHT), "TicTacToe",
                              sf::Style::Close);
  menu_ = new Menu;
}

TicTacToe::~TicTacToe ()
{
  delete menu_;
  delete win_;
}

void
TicTacToe::launch ()
{
  sf::Event event;
  sf::Color white(255, 255, 255);
  Player current_player = None, winner = None;
  int round = 0;
  Board *board = NULL;

  while (win_->IsOpened()) {
    while (win_->GetEvent(event)) {
      const sf::Input &input = win_->GetInput();
      switch (event.Type) {
      case sf::Event::Closed:
        win_->Close();
        break;
      case sf::Event::MouseMoved:
        if (current_player == None) {
          menu_->setCurrentButton(input.GetMouseX(), input.GetMouseY());
        }
        else {
          board->setCurrentCell(input.GetMouseX(), input.GetMouseY());
        }
        break;
      case sf::Event::MouseButtonPressed:
        if (current_player == None) {
          switch (menu_->getAction()) {
          case Exit:
            win_->Close();
            break;
          case NewGame:
            if (board != NULL) delete board;
            board = new Board;
            winner = None;
            current_player = X;
            round = 1;
            break;
          default: break;
          }
        }
        else {
          if (board->play(current_player)) {
            round++;
            winner = board->getWinner();
            if (current_player == X) current_player = O;
            else current_player = X;
          }
        }
        break;
      default: break;
      }
    }

    win_->Clear(white);

    if (round == 0) {
      menu_->display(win_);
    }
    else if (winner != None || round > 9) {
      current_player = None;
      menu_->displayWinner(win_, winner);
    }
    else {
      board->displayGrid(win_);
      board->showNextMove(win_, current_player);
    }

    win_->Display();
  }

  if (board != NULL) delete board;
}
