#include <SFML/Graphics.hpp>
#include "main.hpp"
#include "menu.hpp"
#include "button.hpp"

Button::Button (std::string text, Action action, int position)
  : text_(sf::String(text))
  , action_(action)
{
  sf::FloatRect zone = text_.GetRect();
  text_.SetPosition((GAME_WIDTH - (zone.Right - zone.Left)) / 2,
                    GAME_WIDTH / 2 + (position * (zone.Bottom - zone.Top +
                                                  CELL_PADDING * 3)));
  text_.SetColor(sf::Color(0, 0, 0));
  zone_ = text_.GetRect();
}

Button::~Button ()
{}

bool
Button::contains (int mouse_x, int mouse_y)
{
  return zone_.Contains(mouse_x, mouse_y);
}

Action
Button::getAction ()
{
  return action_;
}

void
Button::display (sf::RenderTarget *rt)
{
  rt->Draw(text_);
}

void
Button::displayActive (sf::RenderTarget *rt)
{
  rt->Draw(sf::Shape::Rectangle(zone_.Left - 10, zone_.Top - 5,
                                zone_.Right + 10, zone_.Bottom + 10,
                                sf::Color(190, 255, 190)));
  display(rt);
}
