#include <list>
#include <SFML/Graphics.hpp>
#include "main.hpp"
#include "board.hpp"
#include "menu.hpp"

Menu::Menu ()
{
  current_button_ = NoAction;

  buttons_.push_front(new Button("New Game", NewGame, 1));
  buttons_.push_front(new Button("Exit", Exit, 2));

  title_ = sf::String("Welcome to\nTicTacToe!");
  title_.SetSize(42);
  sf::FloatRect zone = title_.GetRect();
  title_.SetPosition((GAME_WIDTH - (zone.Right - zone.Left)) / 2,
                  CELL_WIDTH);
  title_.SetColor(sf::Color(0, 0, 0));
}

Menu::~Menu ()
{}

void
Menu::display (sf::RenderTarget *rt)
{
  rt->Draw(title_);
  displayButtons(rt);
}

void
Menu::setCurrentButton (int mouse_x, int mouse_y)
{
  current_button_ = NoAction;
  for (auto b : buttons_) {
    if (b->contains(mouse_x, mouse_y)) {
      current_button_ = b->getAction();
      return;
    }
  }
}

Action
Menu::getAction ()
{
  return current_button_;
}

void
Menu::displayWinner (sf::RenderTarget *rt, Player winner)
{
  if (winner == None) {
    sf::String msg("It's a tie!");
    sf::FloatRect zone = msg.GetRect();
    msg.SetPosition((GAME_WIDTH - (zone.Right - zone.Left)) / 2,
                    CELL_WIDTH / 2);
    msg.SetColor(sf::Color(0, 0, 0));
    rt->Draw(msg);
  }
  else {
    sf::String msg("Le gagnant est");
    sf::FloatRect zone = msg.GetRect();
    msg.SetPosition((GAME_WIDTH - (zone.Right - zone.Left)) / 2,
                    CELL_WIDTH / 2);
    msg.SetColor(sf::Color(0, 0, 0));
    rt->Draw(msg);

    sf::Vector2i center(GAME_WIDTH / 2, GAME_HEIGHT / 2 - CELL_PADDING * 5);
    switch (winner) {
    case X:
      Board::drawX(rt, center);
      break;
    case O:
      Board::drawO(rt, center);
      break;
    default: break;
    }
  }

  displayButtons(rt);
}

void
Menu::displayButtons (sf::RenderTarget *rt)
{
  for (auto b : buttons_) {
    if (current_button_ == b->getAction()) {
      b->displayActive(rt);
    }
    else {
      b->display(rt);
    }
  }
}
