#ifndef BOARD_HPP
#define BOARD_HPP

#include <SFML/Graphics.hpp>
#include "cell.hpp"
#include "main.hpp"

class Board
{
public:
  Board ();
  ~Board ();

  void setCurrentCell (int mouse_x, int mouse_y);
  bool play (Player player);

  Player getWinner ();

  void displayGrid (sf::RenderTarget *rt);
  void showNextMove (sf::RenderTarget *rt, Player player);

  static void drawX (sf::RenderTarget *rt, sf::Vector2i center, int opacity = 255);
  static void drawO (sf::RenderTarget *rt, sf::Vector2i center, int opacity = 255);

private:
  Cell *cells_[9];
  int current_cell_;
};

#endif // BOARD_HPP
