#include <iostream>
#include <cstdlib>
using namespace std;

#define SIZE -1

class Stack
{
public:
  Stack ();
  ~Stack ();

  void push (int value);
  int pop ();

  int length ();
  int size ();

  void iter (void (*f)(int));
  Stack *map (int (*f)(int));
  int reduce (int (*f)(int, int), int base);

private:
  int array_[10];
  int length_;
};

Stack::Stack ()
  : length_(0)
{}

Stack::~Stack ()
{}

void Stack::push (int value)
{
  array_[length_++] = value;
}

int Stack::pop ()
{
  if (length_ <= 0) {
    cerr << "[Stack] can't pop: empty." << endl;
    exit(EXIT_FAILURE);
  }
  return array_[--length_];
}

int Stack::length ()
{
  return length_;
}

void Stack::iter (void (*f)(int))
{
  for (int i = 0; i < length_; i++) {
    f(array_[i]);
  }
}

Stack *Stack::map (int (*f)(int))
{
  int *tmp = new int[SIZE];

  for (int i = 0; i < length_; i++) {
    tmp[i] = f(array_[i]);
  }

  Stack *s = new Stack();

  for (int i = 0; i < length_; i++) {
    s->push(tmp[i]);
  }

  return s;
}

int Stack::reduce (int (*f)(int, int), int base)
{
  int acc = base;

  for (int i = 0; i < length_; i++) {
    acc = f(acc, array_[i]);
  }

  return acc;
}

void display_num (int n)
{
  cout << n << endl;
}

int multiply_by_2 (int n)
{
  return n * 2;
}

int add (int a, int b)
{
  return a + b;
}

int mul (int a, int b)
{
  return a * b;
}

int main (int argc, char *argv[])
{
  Stack *s = new Stack();

  s->push(1);
  s->push(2);
  s->push(3);
  s->push(4);
  s->push(5);
  s->push(6);
  s->push(7);
  s->push(8);
  s->push(9);
  s->push(10);

  cout << "Contenu de s :" << endl;
  s->iter(display_num);
  cout << endl;

  s->pop();
  s->pop();
  s->pop();
  s->pop();

  cout << "Contenu de s :" << endl;
  s->iter(display_num);
  cout << endl;

  Stack *s2 = s->map(multiply_by_2);
  delete s;

  cout << "Contenu de s2 :" << endl;
  s2->iter(display_num);
  cout << endl;

  int sum = s2->reduce(add, 0);
  int product = s2->reduce(mul, 1);

  cout << "Somme des éléments de s2 :" << endl;
  display_num(sum);
  cout << "Produit des éléments de s2 :" << endl;
  display_num(product);
  cout << endl;

  s->push(4);
  s->push(3);
  s->push(2);
  s->push(1);
  s->push(0);

  cout << "Contenu de s :" << endl;
  s->iter(display_num);
  cout << endl;

  return 0;
}
// Merci à olasd, elarnon, et louis pour les idées de bugs…
