#include "person.hpp"
#include <iostream>
using namespace std;

// initialisation des membres statiques
// ------------------------------------

int Person::census_ = 0;

// constructeurs
// -------------

Person::Person ()
  : id_(census_)
  , friends_count_(0)
{
  census_++;
  friends_ = new int[MAX_FRIEND_COUNT];
}

Person::Person (string name)
  : id_(census_)
  , friends_count_(0)
{
  census_++;
  friends_ = new int[MAX_FRIEND_COUNT];
  set_name(name);
}

Person::Person (const Person &p)
  : id_(p.id_)
  , friends_count_(p.friends_count_)
  , name_(p.name_)
{
  friends_ = new int[MAX_FRIEND_COUNT];
  for (int i = 0; i < friends_count_; i++) {
    friends_[i] = p.friends_[i];
  }
}

// destructeur
// -----------

Person::~Person ()
{
  delete[] friends_;
}

// accesseurs
// ----------

void Person::set_name (string name)
{
  if (name.find_first_of("0123456789") != string::npos) {
    cerr << "Le nom '" << name << "' est invalide." << endl;
    return;
  }
  name_ = name;
}

string Person::name () const
{
  return name_;
}

int Person::census ()
{
  return census_;
}

// méthodes
// --------

void Person::introduceSelf () const
{
  cout << "Bonjour, je suis " << name_ << '.' << endl;
}

void Person::addFriend (const Person &p)
{
  if (!isFriendWith(p)) {
    friends_[friends_count_++] = p.id_;
  }
}

bool Person::isFriendWith (const Person &p) const
{
  for (int i = 0; i < friends_count_; i++) {
    if (friends_[i] == p.id_) {
      return true;
    }
  }
  return false;
}
