#ifndef PERSON_HPP___
#define PERSON_HPP___

#include <string>
using namespace std;

#define MAX_FRIEND_COUNT 100

class Person
{
public:
  Person ();
  Person (string name);
  Person (const Person &p);
  ~Person ();

  void set_name (string name);
  string name () const;

  static int census ();

  void introduceSelf () const;
  void addFriend (const Person &p);
  bool isFriendWith (const Person &p) const;

private:
  static int census_;
  const int id_;
  int friends_count_;
  string name_;
  int *friends_;
};

#endif // PERSON_HPP___
