#include "poem.hpp"
#include "person.hpp"
#include <iostream>
using namespace std;

// constructeurs
// -------------

Poem::Poem (string author, int verses_count)
  : verses_count_(verses_count)
{
  author_ = new Person(author);
  verses_ = new string[verses_count];
}

Poem::Poem (Person author, int verses_count)
  : verses_count_(verses_count)
{
  author_ = new Person(author);
  verses_ = new string[verses_count];
}

// destructeur

Poem::~Poem ()
{
  delete author_;
  delete[] verses_;
}

// accesseurs
// ----------

void Poem::set_author (string author)
{
  author_->set_name(author);
}

void Poem::set_author (Person author)
{
  author_ = new Person(author);
}

Person Poem::author ()
{
  return *author_;
}

void Poem::set_verses (string *verses)
{
  for (int i = 0; i < verses_count_; i++) {
    verses_[i] = verses[i];
  }
}

// méthodes
// --------

void Poem::display ()
{
  unsigned int longest_verse_size = 0;
  int space_number;

  cout << endl;
  for (int i = 0; i < verses_count_; i++) {
    cout << ' ' << verses_[i] << endl;
    if (longest_verse_size < verses_[i].length()) {
      longest_verse_size = verses_[i].length();
    }
  }
  cout << endl;

  space_number = longest_verse_size - author_->name().length() - 2;
  for (int i = 0; i < space_number; i++) {
    cout << ' ';
  }
  cout << "~ " << author_->name() << endl << endl;
}
