#include "iterable.hpp"

void Iterable::iter (void (*f)(int))
{
  if (isEmpty()) return;
  begin();
  f(current());
  while (!isAtEnd()) {
    step();
    f(current());
  }
}

void Iterable::map (int (*f)(int))
{
  if (isEmpty()) return;
  begin();
  current() = f(current());
  while (!isAtEnd()) {
    step();
    current() = f(current());
  }
}
