#include <iostream>
#include "stack.hpp"
#include "expression.hpp"
#include "exceptions.hpp"
#include "repl.hpp"

REPL::REPL (std::istream &in, std::ostream &out, std::ostream &err)
  : in_(in)
  , out_(out)
  , err_(err)
{
  stack_ = new Stack;

  if (out_ == std::cout && in_ == std::cin) {
    out_ << "Welcome to RPN Calc!\nHit ^D to exit." << std::endl;
  }
}

REPL::~REPL ()
{
  delete stack_;

  if (out_ == std::cout && in_ == std::cin) {
    out_ << "Bye." << std::endl;
  }
}

Expression *
REPL::read ()
{
  Expression *expr = NULL;

  char next = in_.peek();
  while (next == ' ' || next == '\n') {
    next = in_.get();
    next = in_.peek();
  }

  if (in_.eof()) {
    throw new CtrlD;
  }

  else if ((next >= '0') && (next <= '9')) { // reading a number
    int val;
    in_ >> val;
    expr = new Expression(val);
  }
  else { // reading an operator
    char op;
    in_ >> op;
    switch (op) {
    case '+':
      expr = new Expression(Expression::AddOperator);
      break;
    case '-':
      expr = new Expression(Expression::SubOperator);
      break;
    case '*':
      expr = new Expression(Expression::MulOperator);
      break;
    case '/':
      expr = new Expression(Expression::DivOperator);
      break;
    case '%':
      expr = new Expression(Expression::ModOperator);
      break;
    }
  }

  return expr;
}

void
REPL::eval (Expression *expr)
{
  if (expr->type() == Expression::Number) {
    stack_->push(expr->val());
  }
  else {
    int a = stack_->pop();
    int b = stack_->pop();
    switch (expr->type()) {
    case Expression::AddOperator:
      stack_->push(b + a);
      break;
    case Expression::SubOperator:
      stack_->push(b - a);
      break;
    case Expression::MulOperator:
      stack_->push(b * a);
      break;
    case Expression::DivOperator:
      stack_->push(b / a);
      break;
    case Expression::ModOperator:
      stack_->push(b % a);
      break;
    }
  }

  delete expr;
}

void
REPL::print ()
{
  stack_->print(out_);
  out_ << std::endl;
}

void
REPL::loop ()
{
  for (;;) {
    try {
      out_ << "> ";
      while (in_.good()) {
        eval(read());
        if (in_.peek() == '\n') {
          print();
          out_ << "> ";
        }
      }
    }
    catch (CtrlD *exn) {
      out_ << "^D" << std::endl;
      delete exn;
      break;
    }
    catch (EmptyStack *exn) {
      err_ << "ERROR: " << exn->what() << std::endl;
      delete exn;
      continue;
    }
  }
}
