#include <cstdlib>
#include "exceptions.hpp"
#include "stack.hpp"

class Node
{
  Node (int expr, Node *next = NULL)
    : expr_(expr)
    , next_(next)
  {}

  ~Node ()
  {
    if (next_ != NULL) {
      delete next_;
    }
  }

  int expr_;
  Node *next_;

  friend class Stack;
};

Stack::Stack ()
  : top_(NULL)
  , size_(0)
{}

Stack::~Stack ()
{
  delete top_;
}

void
Stack::push (int expr)
{
  top_ = new Node(expr, top_);
  size_++;
}

int
Stack::peek ()
{
  if (top_ == NULL) {
    throw new EmptyStack;
  }

  return top_->expr_;
}

int
Stack::pop ()
{
  if (top_ == NULL) {
    throw new EmptyStack;
  }

  Node *tmp = top_;
  int expr = tmp->expr_;

  top_ = top_->next_;
  size_--;

  tmp->next_ = NULL;
  delete tmp;

  return expr;
}

int
Stack::size ()
{
  return size_;
}

void
Stack::print (std::ostream &out)
{
  Node *tmp = top_;

  out << "[ ";
  while (tmp != NULL) {
    out << tmp->expr_ << ' ';
    tmp = tmp->next_;
  }
  out << ']';
}
