#include <SFML/Graphics.hpp>
#include "palette.hpp"
#include "tools.hpp"
#include "statusbar.hpp"
#include "minipaint.hpp"

MiniPaint::MiniPaint ()
{
  win_ = new sf::RenderWindow(sf::VideoMode(640, 480), "MiniPaint");
  palette_ = new Palette(win_);
  tools_ = new Tools(win_);
  status_bar_ = new StatusBar(win_, tools_, palette_);
}

MiniPaint::~MiniPaint ()
{
  delete status_bar_;
  delete tools_;
  delete palette_;
  delete win_;
}

void
MiniPaint::run ()
{
  sf::Color white(255, 255, 255);

  while (win_->IsOpened()) {
    // à compléter

    win_->Clear(white);
    for (auto s : shapes) {
      win_->Draw(s);
    }

    // à compléter

    win_->Display();
  }
}
