#include <SFML/Graphics.hpp>
#include "tools.hpp"

Tools::Tools (sf::RenderWindow *win)
  : win_(win)
  , active_(Line)
  , drawing_(false)
{}

Tools::ToolType
Tools::getActiveTool () const
{
  return active_;
}

void
Tools::switchTool (sf::Key::Code k)
{
  prev_ = active_;
  switch (k) {
  case sf::Key::P:
    active_ = Palette;
    break;
  case sf::Key::L:
    active_ = Line;
    break;
  case sf::Key::R:
    active_ = Rectangle;
    break;
  case sf::Key::C:
    active_ = Circle;
    break;
  default: break;
  }
}

void
Tools::switchBack ()
{
  active_ = prev_;
}

void
Tools::setPosition (int x, int y)
{
  x_ = x;
  y_ = y;
  drawing_ = true;
}

bool
Tools::isDrawing ()
{
  return drawing_;
}

sf::Shape
Tools::makeShape (sf::Color c, bool final)
{
  sf::Shape s;

  switch (active_) {
    // à compléter
  default:
    s = sf::Shape::Circle(x_, y_, 1.0, c);
    break;
  }

  if (final) {
    drawing_ = false;
  }

  return s;
}
