#ifndef TOOLS_HPP
#define TOOLS_HPP

#include <SFML/Graphics.hpp>

class Tools
{
public:
  typedef enum { Palette, Line, Circle, Rectangle } ToolType;

  Tools (sf::RenderWindow *win);

  ToolType getActiveTool () const;
  void switchTool (sf::Key::Code k);
  void switchBack ();

  void setPosition (int x, int y);
  bool isDrawing ();

  sf::Shape makeShape (sf::Color c, bool final = false);

private:
  sf::RenderWindow *win_;
  ToolType active_, prev_;

  int x_, y_;
  bool drawing_;
};

#endif // TOOLS_HPP
